require.config({
  paths: {
    jwplayer: "../../../attachment/xwiki/Macros/JWPlayer/jwplayer"
  },
  shim: {
    jwplayer: {
      exports: 'jwplayer'
    }
  }
});
require(['jQueryNoConflict', 'jwplayer'], function($, jwplayer) {
  $('.jwplayer').each(function(index) {
    var options = {
      file: this.alt
    };
    if($(this).hasClass('autostart')){
      options.autostart = true;
    }
    if($(this).hasClass('repeat')){
      options.repeat = true;
    }
    var width = $(this).attr('width');
    width && (options.width = width);
    var height = $(this).attr('height');
    height && (options.height = height);
    this.id = this.id || ('jwplayer' + index);
    jwplayer(this.id).setup(options);
  });
});
